<?php $__env->startSection("title", "Post Detail"); ?>

<?php $__env->startSection("content"); ?>

<a href="<?php echo e(route('posts.index')); ?>" class="btn btn-secondary mb-3">
    Back
</a>

<div class="card">
    <div class="card-header">
        <h4><strong>Title :</strong> <?php echo e($post->title); ?></h4>
    </div>

    <div class="card-body">
        <p><strong>Category:</strong> <?php echo e($post->category->name ?? 'No Category'); ?></p>
        <p><strong>Author:</strong> <?php echo e($post->user->name ?? 'Guest'); ?></p>

        <p>
            <strong>Status:</strong>
            <span class="badge
                <?php echo e($post->status == 'published' ? 'bg-primary'
                : ($post->status == 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                <?php echo e(ucfirst($post->status)); ?>

            </span>
        </p>

        <?php if($post->image): ?>
            <img src="<?php echo e(asset('storage/' . $post->image)); ?>"
                 class="img-fluid mb-3"
                 style="max-width: 300px;">
        <?php endif; ?>

        <hr>

        <p><strong>Content :</strong><?php echo nl2br(e($post->content)); ?></p>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Desktop/blogApp/resources/views/posts/show.blade.php ENDPATH**/ ?>